#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Spiral Optical Illusion Mod01.fsh  by   cnlohr 
//https://www.shadertoy.com/view/ftyyWR
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Illusion based on https://twitter.com/Rainmaker1973/status/1561322229559726080

const bool grey_bars = false;

vec3 CalcColor( vec2 uvz )
{

    bool showdiamonds = true; //fract(iTime*0.1)>0.5;
    
    // THIS LINE is really cool.  The diamonds are what are **the key** to this illusion.
    bool checkdiamonds = true;// fract(iTime*0.1)>0.5;   //XXX HEY, YOU!!! PLAY WITH TURNING THIS ON AND OFF.
    
    float spin_speed = 0.15;
    float zoom_speed = 0.3;
    const float segpairs = 18.0;
    
    vec2 thetar = vec2(atan( uvz.x, uvz.y ), length( uvz ) );

    const float PI = 3.14159265;
    const float TAU = PI * 2.0;
    
    thetar.x += PI;
    
    thetar.x += iTime*spin_speed;
    
    float segno;
    float segplace = (thetar.x * segpairs / TAU);
    segplace = modf( segplace, segno );

    // For debugging
    //return vec3( thetar.y );
    float oneoverr = mix( 40.0, 1.0, pow( 1.0/thetar.y, 0.07) );
    oneoverr += 0.5;
    
    
    oneoverr += iTime * zoom_speed;
    
    float oneoverrf = fract( oneoverr );

    // Neat effect.
    //return vec3( min( fract(segplace + oneoverrf), fract(segplace - oneoverrf) ) );

    float diamondmr = fract(oneoverrf*2.0);
    float diamondms = fract(segplace*2.0);
    float diamondr = abs(0.5-diamondmr);
    float diamonds = abs(0.5-fract(diamondms+diamondmr));
    float diamondp = abs(0.5-fract(diamondms));
    float diamondt = abs(0.5-fract(diamondms-diamondmr));
    float diamondinten = min( min( diamondr, diamonds ), min( diamondp, diamondt ) );

    // Uncomment for another neat effect.
    //return vec3(  min( diamondr, diamonds ) );

    float offset = floor(fract(oneoverr/2.0)*2.0)*0.5;
    // For debugging
    //return vec3( offset) ;

    vec3 col = vec3( 1.0 );
    
    if( diamondinten > 0.17 && showdiamonds )// duva > 0.0 )
    {
        col = vec3((diamondr-diamondp)>0.0);
        // Uncomment for a neat shape.
        //return vec3( abs(  0.5 - segplace  )>0.25);
        if( !checkdiamonds ) 
            segplace = 0.0;
            
        if( (fract(oneoverr*0.5+0.4)>0.5) ^^ ( fract( abs( 0.5 - segplace ) ) > 0.25 ) )
            col = 1.0-col;
    }
    else
    {
        if( oneoverrf < 0.5 )
        {
            col = (fract( segplace + offset ) > 0.5)?vec3( 1.0, 1.0, 1.0 ):vec3( 0.0, 0.0, 0.0 );
        }
        else
        {
           col = (fract( segplace + offset + 0.25 ) > 0.5)?vec3( 0.1, 0.6, 1.0 ):vec3( 0.1, 1.0, 1.0 );
        }
    }
    return col;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.xy;
    vec2 uvz = uv * 2. - 1.;
    
    // Grey bars on the sides.
    if( grey_bars )
        if( uvz.x < -iResolution.y/iResolution.x || uvz.x > iResolution.y/iResolution.x ) { fragColor = vec4( 0.5);  } //return;
    
    // Make it square.
    uvz.x *= iResolution.x/iResolution.y;
 
    vec3 col = vec3( 0.0 );
    float count = 0.0;
    
    // Anti-alias it to mush.
    vec2 uvofsl = vec2(1.3/iResolution.xy);
    vec2 ofs = -uvofsl;
    for( ; ofs.x <= uvofsl.x; ofs.x += uvofsl.x*0.3 )
    {
        for( ofs.y = -uvofsl.y; ofs.y <= uvofsl.y; ofs.y += uvofsl.y*0.3 )
        {
            col += CalcColor( uvz+ofs );
            count ++;
        }
    }
    
    // Output to screen
    fragColor = vec4(col/count,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

